function [croppedObjectsTemp, croppedObjectsThreshTemp] = manualObjectSplitter(imgGP, imgThresh, ax)     

% Initialize vars
croppedObjectsTemp = cell(2,1);
croppedObjectsThreshTemp = cell(2,1);

% Crop objects
objectCrop = imfreehand(ax);
mask = objectCrop.createMask(); % create area mask
mask(isnan(imgGP)) = 0;
croppedObjectsTemp{1} = imgGP;
croppedObjectsTemp{2} = imgGP;
croppedObjectsTemp{1}(~mask) = nan; % apply mask
croppedObjectsTemp{2}(mask) = nan; % remove ROI from original image

% Remove small regions from drawn region
stats = sort(cell2mat(struct2cell(regionprops(mask,'Area'))));
largestRegion = stats(end);
singleObject = bwareaopen(mask, largestRegion-1);
objectExtents = regionprops(singleObject, 'BoundingBox');

% Crop single object by extents
croppedObjectsTemp{1} = imcrop(croppedObjectsTemp{1}, objectExtents(1).BoundingBox); % crop image

% NaN padding to prevent object from touching border
croppedObjectsTemp{1} = padarray(croppedObjectsTemp{1}, [1,1]);
croppedObjectsTemp{1}(1,:) = nan;
croppedObjectsTemp{1}(end,:) = nan;
croppedObjectsTemp{1}(:,1) = nan;
croppedObjectsTemp{1}(:,end) = nan;

% Apply segmentation to pre-processed images
for c=1:length(imgThresh) % for each wavelength in c-stack
    % For drawn ROI
    croppedObjectsThreshTemp{1}{c} = imgThresh{c};    
    croppedObjectsThreshTemp{1}{c}(~mask) = nan; % apply mask
    croppedObjectsThreshTemp{1}{c} = imcrop(croppedObjectsThreshTemp{1}{c}, objectExtents(1).BoundingBox);
    croppedObjectsThreshTemp{1}{c} = padarray(croppedObjectsThreshTemp{1}{c}, [1,1]);
    
    % For remaining image
    croppedObjectsThreshTemp{2}{c} = imgThresh{c};
    croppedObjectsThreshTemp{2}{c}(mask) = nan; % apply mask
end

end